@extends('layouts.app')

@section('content')
<div class="container-fluid">

    {{-- Welcome --}}
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <h5 class="mb-0">
                Welcome, <strong>{{ auth()->user()->name }}</strong> 👋
            </h5>
        </div>
    </div>

    {{-- Admin Section --}}
    @can('manage users')
        <div class="card shadow-sm">
            <div class="card-body">
                <h5 class="mb-3">Admin Panel</h5>

                <div class="d-flex gap-3">
                    <a href="{{ route('admin.users.index') }}"
                       class="btn btn-primary">
                        <i class="bi bi-people"></i> Users
                    </a>

                    <a href="{{ route('admin.roles.index') }}"
                       class="btn btn-success">
                        <i class="bi bi-shield-lock"></i> Roles
                    </a>

                    <a href="{{ route('admin.permissions.index') }}"
                       class="btn btn-warning text-white">
                        <i class="bi bi-key"></i> Permissions
                    </a>
                </div>
            </div>
        </div>
    @endcan

</div>
@endsection
